<?php
/* @var $this KampanieController */
/* @var $budynki Budynek[] */
/* @var $rodzaje RodzajKampanii[] */
/* @var $model Kampanie */

$this->pageTitle = 'Kampanie - ' . Yii::app()->name;

$this->breadcrumbs = array(
	'Kampanie'
);

?>
<h1>Kampanie</h1>

<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('/administration/kampanie/create') ?>">Dodaj nową kampanię</a>

<?php

$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'kampanie-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		'id',
		array(
			'name'=>'idRodzajKampanii',
			'value'=>'$data->rodzaj->nazwa',
		),
		array(
			'name'=>'cenaDzien',
			'value'=>'number_format($data->cenaDzien, 2, ",", " ")',
		),
		array(
			'name'=>'cenaTydzien',
			'value'=>'number_format($data->cenaTydzien, 2, ",", " ")',
		),
		array(
			'name'=>'cenaMiesiac',
			'value'=>'number_format($data->cenaMiesiac, 2, ",", " ")',
		),
		array(
			'name'=>'idBudynku',
			'value'=>'"<a target=\"_blank\" href=\"" . Yii::app()->createUrl("/administration/budynek/view", array("id"=>$data->idBudynku)) . "\">" . $data->budynek->nazwa . "</a>"',
			'type' => 'raw'
		),
		array(
			'class'=>'CButtonColumn',
			'template'=>'{view}{update}'
		),
	),
));

?>
